#ifndef	_ADT856m_H__
#define	_ADT856m_H__


typedef void (*FUNCTION)();


//----------------------------------------------------//
//           Basic parameters settings                //
//----------------------------------------------------//

int _stdcall adt856_initial(void);
/*
Function: Initialize motion card
Return value:Return value is the quantity of ADT-856 cards in the system. Value 3 indiates
that three cards have been installed and available card numbers are 0, 1 and 2;
Value 0 indicates that no ADT-856 card has been installed;
Value -1 indicates that the drivers of ADT-856 card haven't been installed
*/

int _stdcall adt856_end(void);
/*
Function:Release the resources of motion card
Return value :        0:correct          1:wrong	
*/

int _stdcall adt856_set_stop0_mode(int cardno,int axis,int value,int logic);
/*
Function :Setup of STOP0 signal valid /invalid and logic electric level
Parameter:
cardno	  card number
axis		  axis number(1-4)
value		  0:invalid		 1:valid
logic		  0:low electric stop	 1:high electric stop
Return value:         0:correct          1:wrong
Default modes       Signal is invalidlow electric stop
Notice:
The way to stop rests on that it is A/D drive or uniform acceleration drive. For former it is A/D stop while for latter instant stop. STOP1 and STOP2 are just the same
*/

int _stdcall adt856_set_stop1_mode(int cardno,int axis,int value,int logic);
/*
Function :Setup of STOP1 signal valid /invalid and logic electric level
Parameter:
cardno	  card number
axis		  axis number(1-4)
value		  0:invalid		 1:valid
logic		  0:low electric stop	 1:high electric stop
Return value  :       0:correct          1:wrong
Default modes       Signalinvalidlow electric stop
*/

int _stdcall adt856_set_stop2_mode(int cardno,int axis,int value,int logic);
/*
Function: Setup of STOP2 signal valid /invalid and logic electric level
Parameter:
cardno	  card number
axis		  axis number(1-4)
value		  0:invalid		 1:valid
logic		  0:low electric stop	 1:high electric stop
Return value  :       0:correct          1:wrong
Default modes       Signalinvalidlow electric stop
Notice
STOP2 signal can clear actual position counter when it is valid. Due to the delay of servo system or mechanical system, error may occur in home position if you clear the actual position counter with software after driving. With this function, you can get higher precision.
*/


int _stdcall adt856_set_actualcount_mode(int cardno,int axis,int value,int dir,int freq);
/*
Function :Set working mode of actual position counte
Parameter:
cardno	   card number
axis		axis number(1-4)
value	    Pulse input mode
0:A/B pulse input		
1:Up/Down (PPIN/PMIN) pulse input
dir	   Counting direction
0: A leads B or PPIN pulse input up count
B leads A or PMIN pulse input down count
1:B leads A or PMIN pulse input up count
A leads B or PPIN pulse input down count
freq	 Frequency multiplication of A/B pulse input Invalid for Up/Down pulse input
0: 4     1: 2        2: 1
Return value  :       0:correct          1:wrong
Default modes      A/B pulse inputdirection: 0Frequency multiplication: 4
*/


int _stdcall adt856_set_pulse_mode(int cardno,int axis,int value,int logic,int dir_logic);
/*
Function :Set working mode of output pulse
Parameter :
cardno	     card number
axis		  axis number(1-4)
value		  0:Pulse + Pulse	1:Pulse + Direction
logic		  0:Positive logical pulse		1:Negative logical pulse
dir-logic	0: Positive direction pulse output 	
1:Negative direction pulse output
Return value :         0:correct          1:wrong
Default mode    Pulse + direction; positive logical pulse; Positive logic of direction output signal
*/

int _stdcall adt856_set_limit_mode(int cardno,int axis,int value,int logic);
/*
Function :Set the mode of positive/negative limit input signal nLMT
Parameter :
cardno	     card number
axis		  axis number(1-4)
value		  0:sudden stop		1:decelerated stop0:sudden stop	     1:decelerated stop
logic		  0:low electric valid	1:high electric valid
Return value :        0:correct         1:wrong
Default modes       sudden stoplow electric valid
Notice
The limit signal can't be valid or invalid.
*/

int _stdcall adt856_set_softlimit_mode1(int cardno,int axis,int value);
/*
Function :Set COMP + register as software limit
Parameter
cardno	     card number
axis		  axis number(1-4)
value		  0:invalid			 1:valid
Return value         0:correct          1:wrong
Default modes       invalid
Notice
Software limit is always decelerated stop and the counting value may exceed the setting value. It is necessary to consider this point while setting range
*/

int _stdcall adt856_set_softlimit_mode2(int cardno,int axis,int value);
/*
Function :Set COMP - register as software limit
Parameter
cardno	     card number
axis		  axis number(1-4)
value		  0:invalid			 1:valid
Return value         0:correct          1:wrong
Default modes       invalid
Notice :The same as above
*/


int _stdcall adt856_set_softlimit_mode3(int cardno,int axis,int value);
/*
Function :set COMP+/- registers as the compare objects of software limit
Parameter
cardno	     card number
axis		  axis number(1-4)
value		  0:Logical position counter    1:Actual position counter
Return value         0:correct          1:wrong
Default modes       Logical position counter
This function is the comparison object of setting software limit.
*/

int _stdcall adt856_set_inpos_mode(int cardno,int axis,int value,int logic);
/*
Function :Setting of servo in-position signal nINPOS
Parameter
cardno	     card number
axis		  axis number(1-4)
value		  0:invalid			 1:valid
logic		  0:low electricvalid	 1:high electricvalid
Return value         0:correct          1:wrong
Default modes       invalidlow electricvalid
Notice
Do not select valid if nINPOS isn't connected to servo or stepping motor is used.
*/

int _stdcall adt856_set_alarm_mode(int cardno,int axis,int value,int logic);
/*
Function :Set the working mode of servo alarm signal nALARM
Parameter
cardno	     card number
axis		  axis number(1-4)
value		  0:invalid				1:valid
logic		  0:low electric valid		1:high electric valid
Return value         0:correct             1:wrong
Default modes       invalidlow electric valid
Notice
Do not select valid if nALARM isn't connected to servo or stepping motor is used
*/

int _stdcall adt856_set_ad_mode(int cardno,int axis,int value);
/*
Function :Select linear or S-curve acceleration/deceleration
Parameter
cardno	     card number
axis		  axis number(1-4)
value		  0:linear A/D   1:S-curve A/D
Return value         0:correct          1:wrong
Default modes       linear A/D
*/


int _stdcall adt856_set_dec1_mode(int cardno,int axis,int value);
/*
Function :Select symmetric or asymmetric acceleration/deceleration
Parameter
cardno	    card number
axis		 axis number(1-4)
value	    deceleration  mode
(0: symmetric deceleration, 1: asymmetric deceleration)
Return value         0:correct          1:wrong
Default modes       symmetric acceleration/deceleration
*/

int _stdcall adt856_set_dec2_mode(int cardno,int axis,int value);
/*
Function :Set deceleration mode
Parameter
cardno	     card number
axis		  axis number(1-4)
value		  0:automatic deceleration		1: manual deceleration
Return value         0:correct             1:wrong
Default modes       Automatic deceleration
Notice 
Automatic deceleration is used in most cases. To use manual deceleration, it is necessary to set deceleration point
*/

int _stdcall adt856_set_circle_mode(int cardno,int axis,int value);
/*
Function :Set the variable circle mode of counter
Parameter
cardno	     card number
axis		  axis number(1-4)
value  	     0:invalid			 1:valid
Return value         0:correct          1:wrong
Default modes       invalid
*/

int _stdcall adt856_set_input_filter(int cardno,int axis,int number,int value);
/*
Function :Set the filtering function of input signal
Parameter
cardno	 card number
	axis		 axis number
	number	 Input types
			 1:LMT+LMT-STOP0STOP1
			 2:STOP2
			 3:nINPOSnALARM
			 4:nIN
			 Set the filtering state of the four types input signals above
	value	 0: Filtering invalid       1: Filtering valid
Return value          0:correct          1:wrong
Default modes       invalid
*/


int _stdcall adt856_set_filter_time(int cardno,int axis,int value);
/*
Function :Set the filtering time constant of input signals
Parameter
cardno	   card number
axis		axis number
value	   Range: 1-8
*/

//----------------------------------------------------//
//               Driving status checking              //
//----------------------------------------------------//

int _stdcall adt856_get_status(int cardno,int axis,int *value);
/*
Function:Get the driving status of single axis
Parameter
cardno	      card number
axis		  axis number(1-4)
value		  Index of driving status; the meanings are:
0: Driving stopped
Return value         0:correct          1:wrong
Notice
If single axis driving command is executed, you can send next driving instruction to the axis when the driving of corresponding axis is stopped. Otherwise, previous driving instruction stops immediately and next instruction is executed.
*/


int _stdcall adt856_get_stopdata(int cardno,int axis,int *value);
/*
Function:Get the error stop data of axes
Parameter
cardno	      card number
axis		  axis number(1-4)
value	       Index of error status
	 		  0: No error
Return value         0:correct          1:wrong
*/


int _stdcall adt856_get_inp_status(int cardno,int no,int *value);
/*
Function:Get the driving status of interpolation
Parameter
cardno	      card number
value		 Index of interpolation status
			 0: Interpolation stopped	1: Interpolating
Return value         0:correct          1:wrong
Notice
If interpolation driving command is executed, you can send next driving instruction to the axis when the interpolation driving of corresponding axis is stopped. Otherwise, previous driving instruction stops immediately and next instruction is executed.
*/


int _stdcall adt856_get_inp_status2(int cardno,int no,int *value);
/*
Function:Get the writable status of continuous interpolation
Parameter
cardno	       card number
value		  Index of writing status
0: Unwritable	   1: Writable
Return value         0:correct          1:wrong
Notice
If the driving is stopped, the status is 0. Threrfore, it is necessary to check whether error occurs in continuous interpolation process.
*/


//----------------------------------------------------//
//               Moving parameter settings            //
//----------------------------------------------------//

int _stdcall adt856_set_range(int cardno, int axis,long Value);
/*
Function:set range
Parameter		
cardno	  card number
axis		  axis number(1-4)
value  	  range(8000000-16000)
Return value         0:correct          1:wrong
*/

int _stdcall adt856_set_acac(int cardno, int axis,long Value);
/*
Function:Set the change rate of acceleration/deceleration
Parameter
cardno	 card number
axis		 axis number(1-4)
value	     range(1-65535)
Return value         0:correct          1:wrong
*/


int _stdcall adt856_set_acc(int cardno, int axis,long Value);
/*
Function:Set the value of acceleration
Parameter
cardno	 card number
axis		 axis number(1-4)
value	     range(1-8000)
Return value         0:correct          1:wrong
*/

int _stdcall adt856_set_dec(int cardno, int axis,long Value);
/*
Function:Set the value of deceleration
Parameter
cardno	  card number
axis		  axis number(1-4)
value	      D-value(1-8000)
Return value         0:correct          1:wrong
*/

int _stdcall adt856_set_startv(int cardno, int axis,long Value);
/*
Function:Set the value of start velocity
Parameter
cardno	  card number
axis		  axis number(1-4)
value	  range(1-8000)
Return value         0:correct          1:wrong
*/

int _stdcall adt856_set_speed(int cardno, int axis,long Value);
/*
Function:Set the value of run velocity
Parameter
cardno	  card number
axis		  axis number(1-4)
value	  range(1-8000)
Return value         0:correct          1:wrong
*/

int _stdcall adt856_set_command_pos(int cardno, int axis,long Value);
/*
Function:Set the value of logical position counter
Parameter
cardno	 card number
axis		 axis number(1-4)
value	    range value(-2147483648~+2147483647)
Return value         0:correct          1:wrong
Notice          
You can access the logical position counter in real time
*/


int _stdcall adt856_set_actual_pos(int cardno, int axis,long Value);
/*
Function:Set the value of actual position counter
Parameter
cardno	  card number
axis		  axis number(1-4)
value	     range value(-2147483648~+2147483647)
Return value         0:correct          1:wrong
Notice          
You can access the actual position counter in real time
*/


int _stdcall adt856_set_comp1(int cardno, int axis,long Value);
/*
Function:Set the value of COMP+ register
Parameter
cardno	  card number
axis		  axis number(1-4)
value	     range value(-2147483648~+2147483647)
Return value         0:correct          1:wrong
Notice
You can access the COMP+ register in real time
*/


int _stdcall adt856_set_comp2(int cardno, int axis,long Value);
/*
Function:Set the value of COMP- register
Parameter
cardno	  card number
axis		  axis number(1-4)
value	      range value(-2147483648~+2147483647)
Return value         0:correct          1:wrong
Notice          
You can access the COMP- register in real time
*/


int _stdcall adt856_set_dec_pos(int cardno, int axis,long Value);
/*
Function:Set the value of COMP+ register
Parameter
cardno	  card number
axis		  axis number(1-4)
value	     range value(0~268435455)
Return value         0:correct          1:wrong
Notice
If manual deceleration mode is used, you need to set manual deceleration point first.Manual deceleration point = output pulses - pulses consumed by deceleration
*/


//----------------------------------------------------//
//        Moving parameter checking                   //
//----------------------------------------------------//

int _stdcall adt856_get_command_pos(int cardno,int axis,long *pos);
/*
Function:Get the logical position of axes
Parameter
cardno	  card number
axis		  axis number(1-4)
pos		  Index of logical position value
Return value         0:correct          1:wrong
Notice
You can use this function to get the logical position of axes and it can represent the current position of axes if the motor is not out of step
*/


int _stdcall adt856_get_actual_pos(int cardno,int axis,long *pos);
/*
Function:Get the actual position of axis
Parameter
cardno	  card number
axis		  axis number(1-4)
pos		  Index of actual position value
Return value         0:correct          1:wrong
Notice
You can use this function to get the actual position of axes and you can get the current position of axes even if the motor is out of step.
*/


int _stdcall adt856_get_speed(int cardno,int axis,long *pos);
/*
Function:Get the current driving speed of axes
Parameter
cardno	  card number
axis		  axis number(1-4)
speed	     Index of current driving speed
Return value         0:correct          1:wrong
Notice:Value of actual speed = Getting speed*M = Getting speed*(8000000/R)
*/



int _stdcall adt856_get_ad(int cardno,int axis,long *pos);
/*
Function:Get the current acceleration of axes
Parameter
cardno	  card number
axis		  axis number(1-4)
ad		     Index of current acceleration
Return value         0:correct          1:wrong
*/


//----------------------------------------------------//
//                  Basic driving                     //
//----------------------------------------------------//

int _stdcall adt856_pmove(int cardno,int axis,long pulse);
/*
Function:Single axis quantitative driving
Parameter
		cardno 	    card number
		axis		    axis number(1-4)
		pulse	   output pulses   >0: Positive		 <0: Negative
				    range(-268435455~+268435455)
Return value         0:correct          1:wrong
Notice
You need to set valid speed parameter before writing driving command.
*/

int _stdcall adt856_continue_move(int cardno,int axis,int dir);
/*
Function:Single axis continuous driving
Parameter
		cardno 	  card number
		axis		  axis number(1-4)
		dir		 Driving direction   0: Positive	 1: Negative
Return value         0:correct          1:wrong
	Notice
You need to set valid speed parameter before writing driving command.
*/

int _stdcall adt856_dec_stop(int cardno,int axis);
/*
Function:Stop current driving process in deceleration
Parameter
	cardno	   card number
		axis		   axis number(1-4)
Return value         0:correct          1:wrong
Notice
This command is decelerated stop in acceleration/deceleration driving, process and sudden stop in constant speed driving process.
*/

int _stdcall adt856_sudden_stop(int cardno,int axis);
/*
Function:Stop current driving process immediately
Parameter
cardno	  card number
axis		  axis number(1-4)
Return value         0:correct          1:wrong
Notice
Stop pulse output immediately in acceleration/deceleration and constant speed driving process.
*/

int _stdcall adt856_inp_move2(int cardno,int no,long pulse1,long pulse2);
/*
Function:Two axes linear interpolation
Parameter
cardno	  card number
axis1		  Interpolation axis number1(1-4indicate :XYZA)
axis2      Interpolation axis number2(1-4indicate :XYZA)
pulse1       Moving distance of axis1 
pulse2	       Moving distance of axis2 
Return value         0:correct          1:wrong
	Notice
The interpolation speed takes the speed of the axis with smaller axis number between axis1 and axis2 as the standard.
*/


int _stdcall adt856_inp_cw_arc(int cardno,int no,long x,long y,long i,long j);
/*
Function:Two axes CW arc interpolation
Parameter
cardno	    card number
no          1:X-Y    2:Z-W
x,y		   End point position of arc interpolation (relative to start point)
i,j		 Circle center position of arc interpolation (relative to start point)
Return value         0:correct          1:wrong
Notice
The X-Y interpolation takes the speed of X-axis as base,Y-axis do not need to set.
The Z-W interpolation takes the speed of Z-axis as base,A-axis do not need to set.
*/

int _stdcall adt856_inp_ccw_arc(int cardno,int no,long x,long y,long i,long j);
/*
Function:Two axes CCW arc interpolation
Parameter
cardno	  card number
no          1:X-Y    2:Z-W
x,y		   End point position of arc interpolation (relative to start point)
i,j		 Circle center position of arc interpolation (relative to start point
 Return value         0:correct          1:wrong
Notice
The X-Y interpolation takes the speed of X-axis as base,Y-axis do not need to set.
The Z-W interpolation takes the speed of Z-axis as base,A-axis do not need to set.
*/
								
int _stdcall adt856_inp_move3(int cardno,long pulse1,long pulse2,long pulse3);
/*
Function:Three axes linear interpolation
Parameter
cardno 	   card number
pulse1,pulse2,pulse3	    Moving distance of axis X,Y,Z (range:-8388608~+8388607)
Only X,Y,Z could be used with three axes linear interpolation
Return value         0:correct          1:wrong
Notice 
The interpolation speed takes the speed of the axis X as the standard (axis1).the magnification 
 and running speed of Z-axis must be the same as X-axis.The start speed of Z-Axis must be the same
 as running speed of X-axis (not start speed),Y-axis do not need to set.
*/

int _stdcall adt856_inp_move4(int cardno,long pulse1,long pulse2,long pulse3,long pulse4);
/*
Function:Four axes linear interpolation
Parameter
cardno 	   card number
pulse1       Moving distance of X-axis
pulse2	     Moving distance of Y-axis
pulse3       Moving distance of Z-axis
pulse4	     Moving distance of W-axis
Return value         0:correct          1:wrong
Notice
The interpolation speed takes the speed of the axis X as the standard (axis1).the magnification 
and running speed of Z-axis must be the same as X-axis.The start speed of Z-Axis must be the same
as running speed of X-axis (not start speed),Y,W-axis do not need to set.
*/

int  _stdcall adt856_inp_move6(int cardno,long pulse1,long pulse2,long pulse3,long pulse4,long pulse5,long pulse6);
/*
Function:Four axes linear interpolation
Parameter
cardno 	   card number
pulse1       Moving distance of axis1
pulse2	     Moving distance of axis2
pulse3       Moving distance of axis3
pulse4	     Moving distance of axis4
pulse5       Moving distance of axis5
pulse6	     Moving distance of axis6
Return value         0:correct          1:wrong
Notice
The interpolation speed takes the speed of the axis X as the standard (axis1).the magnification 
and running speed of Z-axis,,U-axis must be the same as X-axis.The start speed of Z-axis,U-axis must be the same
as running speed of X-axis (not start speed),Y ,W, V axis do not need to set.
*/

int _stdcall adt856_inp_dec_enable(int cardno, int no);
/*
Function:Enable deceleration of interpolation
Parameter
cardno	     card number
Return value         0:correct          1:wrong
*/

int _stdcall adt856_inp_dec_disable(int cardno, int no);
/*
Function:Disable deceleration of interpolation
Parameter
cardno	    card number
Return value         0:correct          1:wrong
*/

int _stdcall adt856_inp_clear(int cardno);
/*
Function:clean the error of interpolation 
Parameter
cardno	    card number
Return value         0:correct          1:wrong
*/

//----------------------------------------------------//
//              Switch quantity input/output          //
//----------------------------------------------------//

int _stdcall adt856_read_bit(int cardno,int number);
/*
Function:Get the status of single input bit
Parameter	
cardno	 card number
number	input bit (0-47)
Return value         0:low electric     1:high electric  -1:wrong
*/


int _stdcall adt856_write_bit(int cardno,int number,int value);
/*
Function:Corresponding port performs output operation.
Parameter	
cardno	  card number
number	  output bit(0-31)
value		  0:low		     1:high
Return value         0:correct          1:wrong
*/

#endif